/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.repository;

import java.util.Objects;

public final class RepositoryGame {
    public static final String MIRRORED_ROM = "Mirrored ROM";
    private final String title;
    private final String system;
    private final String company;
    private final String year;
    private final String country;
    private final boolean original;
    private final String originalText;
    private final String mapper;
    private final String start;
    private final String remark;

    public static RepositoryGameParam title(String title) {
        return new RepositoryGameParam().title(title);
    }

    public static RepositoryGameParam system(String system) {
        return new RepositoryGameParam().system(system);
    }

    public static RepositoryGameParam company(String company) {
        return new RepositoryGameParam().company(company);
    }

    public static RepositoryGameParam year(String year) {
        return new RepositoryGameParam().year(year);
    }

    public static RepositoryGameParam country(String country) {
        return new RepositoryGameParam().country(country);
    }

    public static RepositoryGameParam isOriginal(boolean original) {
        return new RepositoryGameParam().isOriginal(original);
    }

    public static RepositoryGameParam originalText(String originalText) {
        return new RepositoryGameParam().originalText(originalText);
    }

    public static RepositoryGameParam mapper(String mapper) {
        return new RepositoryGameParam().mapper(mapper);
    }

    public static RepositoryGameParam start(String start) {
        return new RepositoryGameParam().start(start);
    }

    public static RepositoryGameParam remark(String remark) {
        return new RepositoryGameParam().remark(remark);
    }

    private RepositoryGame(RepositoryGameParam param) {
        this.title = param.title;
        this.system = param.system;
        this.company = param.company;
        this.year = param.year;
        this.country = param.country;
        this.original = param.original;
        this.originalText = param.originalText;
        this.mapper = param.mapper;
        this.start = param.start;
        this.remark = param.remark;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSystem() {
        return this.system;
    }

    public String getCompany() {
        return this.company;
    }

    public String getYear() {
        return this.year;
    }

    public String getCountry() {
        return this.country;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public String getMapper() {
        String mapperValue = this.mapper == null ? MIRRORED_ROM : this.mapper;
        return mapperValue;
    }

    public String getStart() {
        return this.start;
    }

    public String getRemark() {
        return this.remark;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RepositoryGame)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RepositoryGame other = (RepositoryGame)obj;
        return other.getTitle().equals(this.title) && other.getSystem().equals(this.system) && other.getCompany().equals(this.company) && other.getYear().equals(this.year) && other.getCountry().equals(this.country);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.system, this.company, this.year, this.country);
    }

    public static class RepositoryGameParam {
        private String title;
        private String system;
        private String company;
        private String year;
        private String country;
        private boolean original;
        private String originalText;
        private String mapper;
        private String start;
        private String remark;

        public RepositoryGameParam title(String title) {
            this.title = Objects.requireNonNull(title);
            return this;
        }

        public RepositoryGameParam system(String system) {
            this.system = Objects.requireNonNull(system);
            return this;
        }

        public RepositoryGameParam company(String company) {
            this.company = Objects.requireNonNull(company);
            return this;
        }

        public RepositoryGameParam year(String year) {
            this.year = Objects.requireNonNull(year);
            return this;
        }

        public RepositoryGameParam country(String country) {
            this.country = Objects.requireNonNull(country);
            return this;
        }

        public RepositoryGameParam isOriginal(boolean original) {
            this.original = original;
            return this;
        }

        public RepositoryGameParam originalText(String originalText) {
            this.originalText = originalText;
            return this;
        }

        public RepositoryGameParam mapper(String mapper) {
            this.mapper = mapper;
            return this;
        }

        public RepositoryGameParam start(String start) {
            this.start = start;
            return this;
        }

        public RepositoryGameParam remark(String remark) {
            this.remark = remark;
            return this;
        }

        public RepositoryGame build() {
            if (this.title == null || this.system == null || this.company == null || this.year == null || this.country == null) {
                throw new IllegalArgumentException("Title, System, Company, Year and Country must be set");
            }
            return new RepositoryGame(this);
        }
    }
}

